# AN^[Xe[^XpEBhEZbg
# Author:: fukuyama
# Date:: 2008/08/09
# Copyright:: Copyright (C) 2008 rgss-lib

module DQ
  
  class Windowset_Actor_Status
    
    attr_reader :window_summary
    attr_reader :window_detail
    attr_reader :window_equip
    attr_accessor :actor
    
    def initialize(parent,actor,x="center",y="center")
      @parent = parent
      @actor = actor
      
      @actor_status_windows = []
      
      # AN^[ȈՃXe[^X
      @window_summary = Window_Status_Summary.new(@actor)
      @actor_status_windows.push @window_summary
      
      # AN^[ڍ׃Xe[^X
      @window_detail = Window_Status_Detail.new(@actor)
      @actor_status_windows.push @window_detail
      
      # AN^[
      @window_equip = Window_Status_Equip.new(@actor)
      @actor_status_windows.push @window_equip
      
      # wix
      @window_summary.back_opacity = @parent.back_opacity
      @window_detail.back_opacity = @parent.back_opacity
      @window_equip.back_opacity = @parent.back_opacity
      
      # ʒu
      case x
      when Numeric
        @window_summary.left = x
      when "center"
        @window_summary.left = 640 / 2 - (@window_summary.width + @window_detail.width) / 2
      else
        @window_summary.left = 0
      end
      case y
      when Numeric
        @window_summary.top = y
      when "center"
        @window_summary.top  = 480 / 2 - (@window_detail.height) / 2
      else
        @window_summary.top = 0
      end
      @window_detail.left = @window_summary.right
      @window_detail.top  = @window_summary.top
      @window_equip.left = @window_summary.left
      @window_equip.top  = @window_summary.bottom
      
      @actor_status_windows.each do |w|
        w.z = @parent.z + 10
      end
    end
    
    def actor=(actor)
      if @actor != actor
        @actor = actor
        @actor_status_windows.each do |w|
          w.actor = @actor
        end
      end
    end
    
    def update
      @actor_status_windows.each do |w|
        w.update
      end
    end
    
    def dispose
      @actor_status_windows.each do |w|
        w.dispose
      end
      @actor_status_windows.clear
    end
    
  end
  
end